#include <unordered_map>
#include <iostream>
#include <vector>

using std::vector;

void mk_rect(int i, int j, std::unordered_map<int,
             vector<int>> &dict, const vector<vector<int>> &M);
void check_val (int i, int &j, std::unordered_map<int,
                 vector<int>> &dict, const vector<vector<int>> &M);

int main()
{

    int N, K;
    std::cin >> N >> K;
    vector<vector<int>> M;
    for (int i = 0; i != N; ++i) {
        vector<int> rowi;
        for (int j = 0; j != N; ++j) {
            int val = 0;
            std::cin >> val;
            rowi.push_back(val);
        }
        M.push_back(rowi);
    }

    std::unordered_map<int, vector<int>> dict;

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < N; ++j) {
            int val = M[i][j];
            if (dict.find(val) == dict.end())
                mk_rect(i, j, dict, M);
            else
                check_val(i, j, dict, M);
        }
    }

    int cnt = 0;
    auto it = dict.begin();
    while (it != dict.end())
        if ((it++)->second[0])
            ++cnt;
    std::cout << cnt << std::endl;
    return 0;
}
void mk_rect(int i, int j, std::unordered_map<int,
             vector<int>> &dict, const vector<vector<int>> &M)
{
    int val = M[i][j];
    int width = 1, height = 1;
    while (j + width < M[i].size() && M[i][j + width] == val)
        ++width;

    while (i + height < M.size() && M[i + height][j] == val) {
        for (int k = 1; k < width; ++k)
            if (M[i + height][j + k] != val) {
                vector<int> content = {0};
                dict.insert({val, content});
                return;
            }
        ++height;
    }
    vector<int> content = {1, i, j, width, height};
    dict.insert({val, content});
}
void check_val (int i, int &j, std::unordered_map<int,
                 vector<int>> &dict, const vector<vector<int>> &M)
{
    vector<int> content = dict[M[i][j]];
    // not a valid value
    if (!content[0])
        return;
    if (content[2] <= j && j < content[2] + content[3]) {
        if (content[1] <= i && i < content[1] + content[4])
            j = content[2] + content[3] - 1;
        else
            dict[M[i][j]][0] = 0;
    }
    else
        dict[M[i][j]][0] = 0;
}